package ru.yandex.solomon.yasm.expression.grammar;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableMap;

import ru.yandex.solomon.expression.ast.Ast;
import ru.yandex.solomon.expression.value.SelValue;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class ExpressionWithConstants {
    public final Ast expression;
    public final boolean scalar;
    public final Map<String, SelValue> constants;

    private ExpressionWithConstants(Ast expression, boolean scalar, Map<String, SelValue> constants) {
        this.expression = expression;
        this.scalar = scalar;
        this.constants = constants;
    }

    public static ExpressionWithConstants scalar(Ast expression) {
        return of(expression, true);
    }

    public static ExpressionWithConstants series(Ast expression) {
        return of(expression, false);
    }

    public static ExpressionWithConstants of(Ast expression, boolean scalar) {
        return new ExpressionWithConstants(expression, scalar, Map.of());
    }

    public static ExpressionWithConstants scalar(Ast expression, Map<String, SelValue> constants) {
        return of(expression, constants, true);
    }

    public static ExpressionWithConstants series(Ast expression, Map<String, SelValue> constants) {
        return of(expression, constants, false);
    }

    public static ExpressionWithConstants of(Ast expression, Map<String, SelValue> constants, boolean scalar) {
        return new ExpressionWithConstants(expression, scalar, ImmutableMap.copyOf(constants));
    }

    public static ExpressionWithConstants scalar(Ast expression, List<Map<String, SelValue>> constantsArgs) {
        return of(expression, constantsArgs, true);
    }

    public static ExpressionWithConstants series(Ast expression, List<Map<String, SelValue>> constantsArgs) {
        return of(expression, constantsArgs, false);
    }

    public static ExpressionWithConstants of(Ast expression, List<Map<String, SelValue>> constantsArgs, boolean scalar) {
        HashMap<String, SelValue> merged = new HashMap<>();
        for (var constants : constantsArgs) {
            merged.putAll(constants);
        }
        return new ExpressionWithConstants(expression, scalar, ImmutableMap.copyOf(merged));
    }

    public ExpressionWithConstants mapToSeries(UnaryOperator<Ast> mapper) {
        return ExpressionWithConstants.series(mapper.apply(expression), constants);
    }

    public ExpressionWithConstants map(UnaryOperator<Ast> mapper) {
        return new ExpressionWithConstants(mapper.apply(expression), scalar, constants);
    }
}
