package ru.yandex.solomon.yasm.expression.grammar;

import java.util.Arrays;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class SigoptHelper {
    enum AggregationMethod {
        AVER('v'),
        HGRAM('h'),
        MAX('x'),
        MIN('n'),
        SUMM('m'),
        SUMMNONE('e'),
        TRNSP('t'),
        COUNTER('c'),
        ;

        private final char code;

        AggregationMethod(char c) {
            this.code = c;
        }

        @Nullable
        public static AggregationMethod byCode(char c) {
            return Arrays.stream(values())
                    .filter(value -> value.code == c)
                    .findAny()
                    .orElse(null);
        }
    }

    static String expandAlias(String alias) {
        // https://wiki.yandex-team.ru/golovan/userdocs/stat-handle/sigopt/#defoltnyesigopt-suffiksy
        return switch (alias) {
            case "summ" -> "dmmm";
            case "hgram" -> "dhhh";
            case "max" -> "axxx";
            default -> alias;
        };
    }
}
