package ru.yandex.solomon.yasm.expression.grammar;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.yasm.expression.ast.YasmAst;
import ru.yandex.solomon.yasm.expression.ast.YasmAstArgList;
import ru.yandex.solomon.yasm.expression.ast.YasmAstCall;
import ru.yandex.solomon.yasm.expression.ast.YasmAstIdent;
import ru.yandex.solomon.yasm.expression.ast.YasmAstNumber;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public interface YasmAstElementVisitor<T> {
    default T visitArgList(YasmAstArgList argList) {
        throw new UnsupportedOperationException("argList is processed in call");
    }

    T visitCall(YasmAstCall call);

    T visitIdent(YasmAstIdent constant);

    T visitNumber(YasmAstNumber number);

    default T visit(YasmAst ast) {
        switch (ast.getType()) {
            case ARG_LIST:
                return visitArgList((YasmAstArgList) ast);
            case CALL:
                return visitCall((YasmAstCall) ast);
            case IDENT:
                return visitIdent((YasmAstIdent) ast);
            case NUMBER:
                return visitNumber((YasmAstNumber) ast);
        }
        throw new IllegalArgumentException("Unsupported ast type in walkTree: " + ast.getType());
    }
}
