package ru.yandex.solomon.yasm.expression.grammar;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.yasm.expression.ast.YasmAst;
import ru.yandex.solomon.yasm.expression.ast.YasmAstArgList;
import ru.yandex.solomon.yasm.expression.ast.YasmAstCall;
import ru.yandex.solomon.yasm.expression.ast.YasmAstIdent;
import ru.yandex.solomon.yasm.expression.ast.YasmAstNumber;
import ru.yandex.solomon.yasm.grammar.generated.YasmBaseVisitor;
import ru.yandex.solomon.yasm.grammar.generated.YasmParser;


/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
class YasmAstVisitor extends YasmBaseVisitor<YasmAst> {


    @Override
    public YasmAst visitInput(YasmParser.InputContext ctx) {
        return visitExpression(ctx.expression());
    }

    @Override
    public YasmAst visitExpression(YasmParser.ExpressionContext ctx) {
        String ident = ctx.IDENT().getText();
        if (ctx.args() != null) {
            return new YasmAstCall(ident, visitArgs(ctx.args()));
        }
        return new YasmAstIdent(ident);
    }

    @Override
    public YasmAstArgList visitArgs(YasmParser.ArgsContext ctx) {
        if (ctx.args() != null) {
            return visitArgs(ctx.args()).with(visitArg(ctx.arg()));
        }
        if (ctx.arg() != null) {
            return new YasmAstArgList(visitArg(ctx.arg()));
        }
        return new YasmAstArgList();
    }

    @Override
    public YasmAst visitArg(YasmParser.ArgContext ctx) {
        if (ctx.expression() != null) {
            return visitExpression(ctx.expression());
        }
        return new YasmAstNumber(ctx.NUMBER().getText());
    }
}
