package ru.yandex.solomon.yasm.expression.grammar;

import java.util.List;
import java.util.Map;

import ru.yandex.solomon.yasm.expression.ast.YasmAst;
import ru.yandex.solomon.yasm.expression.ast.YasmAstArgList;
import ru.yandex.solomon.yasm.expression.ast.YasmAstCall;
import ru.yandex.solomon.yasm.expression.grammar.functions.Div;
import ru.yandex.solomon.yasm.expression.grammar.functions.Normal;

public class YasmToSelConverter {
    private final String yasmPrefix;

    public YasmToSelConverter(String yasmPrefix) {
        this.yasmPrefix = yasmPrefix;
    }

    public String convertExpression(String signal, Map<String, List<String>> tags, String alias, boolean normalize) {
        StringBuilder builder = new StringBuilder();
        builder.append("// ").append(signal).append("\n");
        YasmAst ast = YasmExpression.parse(signal);
        if (normalize) {
            // expr -> div(expr, normal())
            ast = new YasmAstCall(Div.NAME, new YasmAstArgList(ast, new YasmAstCall(Normal.NAME, new YasmAstArgList())));
        }
        YasmSelRenderer.RenderResult renderResult = YasmSelRenderer.render(ast, tags, yasmPrefix);
        for (var entry : renderResult.constants.entrySet()) {
            builder.append("let ").append(entry.getKey()).append(" = ").append(entry.getValue()).append(";\n");
        }
        String signalExpression = renderResult.expression;
        if (!alias.isEmpty()) {
            builder.append("alias(").append(signalExpression).append(", \"").append(alias).append("\")");
        } else {
            builder.append(signalExpression);
        }

        return builder.toString();
    }
}
