package ru.yandex.solomon.yasm.expression.grammar.functions;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.PositionRange;
import ru.yandex.solomon.expression.ast.AstBinOp;
import ru.yandex.solomon.expression.ast.AstCall;
import ru.yandex.solomon.expression.ast.AstIdent;
import ru.yandex.solomon.expression.ast.AstOp;
import ru.yandex.solomon.expression.expr.func.SelFnConstantLine;
import ru.yandex.solomon.yasm.expression.ast.YasmAst;
import ru.yandex.solomon.yasm.expression.grammar.ExpressionWithConstants;
import ru.yandex.solomon.yasm.expression.grammar.FunctionRenderer;
import ru.yandex.solomon.yasm.expression.grammar.YasmSelRenderer;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class Const implements FunctionRenderer {

    private static final AstIdent CONSTANT_LINE = new AstIdent(PositionRange.UNKNOWN, SelFnConstantLine.NAME);

    static ExpressionWithConstants makeLineArg(YasmSelRenderer renderer, YasmAst ast) {
        ExpressionWithConstants arg = renderer.visit(ast);
        if (arg.scalar) {
            return ExpressionWithConstants.series(
                    new AstCall(PositionRange.UNKNOWN, CONSTANT_LINE, List.of(arg.expression)),
                    arg.constants
            );
        }
        return arg;
    }

    @Override
    public String name() {
        return "const";
    }

    @Override
    public ExpressionWithConstants render(YasmSelRenderer renderer, List<YasmAst> args) {
        if (args.size() < 1 || args.size() > 2) {
            throw new IllegalArgumentException("Expected 1 or 2 argument for const, got: " + args.size());
        }
        if (args.size() == 1) {
            ExpressionWithConstants arg0 = renderer.visit(args.get(0));
            return ExpressionWithConstants.series(
                    new AstCall(PositionRange.UNKNOWN, CONSTANT_LINE, List.of(arg0.expression)),
                    arg0.constants
            );
        } else {
            ExpressionWithConstants arg0 = renderer.visit(args.get(0));
            ExpressionWithConstants unit = Conv.renderUnit(args.get(1));
            return ExpressionWithConstants.series(
                    new AstCall(PositionRange.UNKNOWN,
                            CONSTANT_LINE,
                            List.of(new AstBinOp(PositionRange.UNKNOWN,
                                    arg0.expression,
                                    unit.expression,
                                    new AstOp(PositionRange.UNKNOWN, "*")
                            ))),
                    List.of(arg0.constants, unit.constants)
            );
        }
    }
}
