package ru.yandex.solomon.yasm.expression.grammar.functions;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.PositionRange;
import ru.yandex.solomon.expression.ast.AstBinOp;
import ru.yandex.solomon.expression.ast.AstCall;
import ru.yandex.solomon.expression.ast.AstIdent;
import ru.yandex.solomon.expression.ast.AstOp;
import ru.yandex.solomon.expression.expr.func.SelFnDeltaToRate;
import ru.yandex.solomon.yasm.expression.ast.YasmAst;
import ru.yandex.solomon.yasm.expression.ast.YasmAst.Type;
import ru.yandex.solomon.yasm.expression.ast.YasmAstCall;
import ru.yandex.solomon.yasm.expression.grammar.ExpressionWithConstants;
import ru.yandex.solomon.yasm.expression.grammar.FunctionRenderer;
import ru.yandex.solomon.yasm.expression.grammar.YasmSelRenderer;

import static ru.yandex.solomon.yasm.expression.grammar.functions.Const.makeLineArg;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class Div implements FunctionRenderer {

    public static final String NAME = "div";

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public ExpressionWithConstants render(YasmSelRenderer renderer, List<YasmAst> args) {
        if (args.size() != 2) {
            throw new IllegalArgumentException("Expected 2 arguments for div call, got: " + args.size());
        }

        if (isNormal(args.get(1))) {
            return renderer.visit(args.get(0)).mapToSeries(expression -> new AstCall(PositionRange.UNKNOWN,
                    new AstIdent(PositionRange.UNKNOWN, SelFnDeltaToRate.NAME),
                    List.of(expression)));
        }

        ExpressionWithConstants arg0 = makeLineArg(renderer, args.get(0));
        ExpressionWithConstants arg1 = makeLineArg(renderer, args.get(1));
        AstBinOp result = new AstBinOp(PositionRange.UNKNOWN,
                arg0.expression,
                arg1.expression,
                new AstOp(PositionRange.UNKNOWN, "/"));
        return ExpressionWithConstants.series(result, List.of(arg0.constants, arg1.constants));
    }

    private boolean isNormal(YasmAst arg) {
        if (arg.getType() != Type.CALL) {
            return false;
        }

        var call = (YasmAstCall) arg;
        return call.getFunc().equals(Normal.NAME);
    }
}
