package ru.yandex.solomon.yasm.expression.grammar.functions;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.PositionRange;
import ru.yandex.solomon.expression.ast.AstCall;
import ru.yandex.solomon.expression.ast.AstIdent;
import ru.yandex.solomon.expression.ast.AstValueString;
import ru.yandex.solomon.yasm.expression.ast.YasmAst;
import ru.yandex.solomon.yasm.expression.grammar.ExpressionWithConstants;
import ru.yandex.solomon.yasm.expression.grammar.FunctionRenderer;
import ru.yandex.solomon.yasm.expression.grammar.YasmSelRenderer;

import static ru.yandex.solomon.yasm.expression.grammar.functions.Const.makeLineArg;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class Havg implements FunctionRenderer {

    @Override
    public String name() {
        return "havg";
    }

    @Override
    public ExpressionWithConstants render(YasmSelRenderer renderer, List<YasmAst> args) {
        if (args.size() < 1 || args.size() > 2) {
            throw new IllegalArgumentException("Expected 1 or 2 arguments for havg call, got: " + args.size());
        }
        var result = renderer.visit(args.get(0)).mapToSeries(expression -> new AstCall(PositionRange.UNKNOWN,
                new AstIdent(PositionRange.UNKNOWN, "histogram_avg"),
                List.of(new AstValueString(PositionRange.UNKNOWN, ""), expression)));

        if (args.size() == 1) {
            return result;
        } else {
            ExpressionWithConstants fallback = makeLineArg(renderer, args.get(1));
            return ExpressionWithConstants.series(
                    new AstCall(PositionRange.UNKNOWN,
                            new AstIdent(PositionRange.UNKNOWN, "fallback"),
                            List.of(result.expression, fallback.expression)
                    ),
                    List.of(result.constants, fallback.constants)
            );
        }
    }
}
