package ru.yandex.solomon.yasm.expression.grammar.functions;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.PositionRange;
import ru.yandex.solomon.expression.ast.AstCall;
import ru.yandex.solomon.expression.ast.AstIdent;
import ru.yandex.solomon.expression.ast.AstValueString;
import ru.yandex.solomon.yasm.expression.ast.YasmAst;
import ru.yandex.solomon.yasm.expression.grammar.ExpressionWithConstants;
import ru.yandex.solomon.yasm.expression.grammar.FunctionRenderer;
import ru.yandex.solomon.yasm.expression.grammar.YasmSelRenderer;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class Hsum implements FunctionRenderer {

    @Override
    public String name() {
        return "hsum";
    }

    @Override
    public ExpressionWithConstants render(YasmSelRenderer renderer, List<YasmAst> args) {
        if (args.size() != 1) {
            throw new IllegalArgumentException("Expected 1 argument for hsum call, got: " + args.size());
        }
        return renderer.visit(args.get(0)).mapToSeries(expression -> new AstCall(PositionRange.UNKNOWN,
                new AstIdent(PositionRange.UNKNOWN, "histogram_sum"),
                List.of(new AstValueString(PositionRange.UNKNOWN, ""), expression)));
    }
}
