package ru.yandex.solomon.yasm.expression.grammar.functions;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.PositionRange;
import ru.yandex.solomon.expression.ast.AstBinOp;
import ru.yandex.solomon.expression.ast.AstOp;
import ru.yandex.solomon.yasm.expression.ast.YasmAst;
import ru.yandex.solomon.yasm.expression.grammar.ExpressionWithConstants;
import ru.yandex.solomon.yasm.expression.grammar.FunctionRenderer;
import ru.yandex.solomon.yasm.expression.grammar.YasmSelRenderer;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class Mul implements FunctionRenderer {
    @Override
    public String name() {
        return "mul";
    }

    @Override
    public ExpressionWithConstants render(YasmSelRenderer renderer, List<YasmAst> args) {
        if (args.size() < 1) {
            throw new IllegalArgumentException("Expected at least 1 argument for mul call, got: " + args.size());
        }
        var result = renderer.visit(args.get(0));
        for (int i = 1; i < args.size(); i++) {
            var nextArg = renderer.visit(args.get(i));
            result = ExpressionWithConstants.of(
                    new AstBinOp(PositionRange.UNKNOWN,
                            result.expression,
                            nextArg.expression,
                            new AstOp(PositionRange.UNKNOWN, "*")
                    ),
                    List.of(result.constants, nextArg.constants),
                    result.scalar && nextArg.scalar
            );
        }
        return result;
    }
}
