package ru.yandex.solomon.yasm.expression.grammar.functions;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.PositionRange;
import ru.yandex.solomon.expression.ast.AstBinOp;
import ru.yandex.solomon.expression.ast.AstOp;
import ru.yandex.solomon.expression.ast.AstValueDouble;
import ru.yandex.solomon.yasm.expression.ast.YasmAst;
import ru.yandex.solomon.yasm.expression.grammar.ExpressionWithConstants;
import ru.yandex.solomon.yasm.expression.grammar.FunctionRenderer;
import ru.yandex.solomon.yasm.expression.grammar.YasmSelRenderer;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class Neg implements FunctionRenderer {
    private static final AstValueDouble NEG_ONE = new AstValueDouble(PositionRange.UNKNOWN, -1);

    @Override
    public String name() {
        return "neg";
    }

    @Override
    public ExpressionWithConstants render(YasmSelRenderer renderer, List<YasmAst> args) {
        if (args.size() != 1) {
            throw new IllegalArgumentException("Expected 1 argument for neg, got: " + args.size());
        }
        return renderer.visit(args.get(0)).map(expression -> new AstBinOp(PositionRange.UNKNOWN,
                        NEG_ONE,
                        expression,
                        new AstOp(PositionRange.UNKNOWN, "*")));
    }
}
