package ru.yandex.solomon.yasm.expression.grammar.functions;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.PositionRange;
import ru.yandex.solomon.expression.ast.AstCall;
import ru.yandex.solomon.expression.ast.AstIdent;
import ru.yandex.solomon.expression.expr.func.SelFnGridStep;
import ru.yandex.solomon.yasm.expression.ast.YasmAst;
import ru.yandex.solomon.yasm.expression.grammar.ExpressionWithConstants;
import ru.yandex.solomon.yasm.expression.grammar.FunctionRenderer;
import ru.yandex.solomon.yasm.expression.grammar.YasmSelRenderer;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class Normal implements FunctionRenderer {

    public static final String NAME = "normal";

    private static final AstIdent GRID_STEP_IDENT = new AstIdent(PositionRange.UNKNOWN, SelFnGridStep.NAME);

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public ExpressionWithConstants render(YasmSelRenderer renderer, List<YasmAst> args) {
        return ExpressionWithConstants.scalar(new AstCall(PositionRange.UNKNOWN, GRID_STEP_IDENT, List.of()));
    }
}
