package ru.yandex.solomon.yasm.expression.grammar.functions;

import java.util.List;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.PositionRange;
import ru.yandex.solomon.expression.ast.AstCall;
import ru.yandex.solomon.expression.ast.AstIdent;
import ru.yandex.solomon.yasm.expression.ast.YasmAst;
import ru.yandex.solomon.yasm.expression.grammar.ExpressionWithConstants;
import ru.yandex.solomon.yasm.expression.grammar.FunctionRenderer;
import ru.yandex.solomon.yasm.expression.grammar.YasmSelRenderer;

import static ru.yandex.solomon.yasm.expression.grammar.functions.Const.makeLineArg;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class Or implements FunctionRenderer {
    @Override
    public String name() {
        return "or";
    }

    @Override
    public ExpressionWithConstants render(YasmSelRenderer renderer, List<YasmAst> args) {
        if (args.size() != 2) {
            throw new IllegalArgumentException("Expected exactly 2 arguments for " + name() + " call, got: " + args.size());
        }

        List<ExpressionWithConstants> signals = args.stream()
                .map(arg -> makeLineArg(renderer, arg))
                .collect(Collectors.toList());
        return ExpressionWithConstants.series(
                new AstCall(PositionRange.UNKNOWN,
                        new AstIdent(PositionRange.UNKNOWN, "fallback"),
                        signals.stream().map(x -> x.expression).collect(Collectors.toList())
                ),
                signals.stream().map(x -> x.constants).collect(Collectors.toList())
        );
    }
}
