package ru.yandex.solomon.yasm.expression.grammar.functions;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.PositionRange;
import ru.yandex.solomon.expression.ast.AstBinOp;
import ru.yandex.solomon.expression.ast.AstOp;
import ru.yandex.solomon.expression.ast.AstValueDouble;
import ru.yandex.solomon.yasm.expression.ast.YasmAst;
import ru.yandex.solomon.yasm.expression.grammar.ExpressionWithConstants;
import ru.yandex.solomon.yasm.expression.grammar.FunctionRenderer;
import ru.yandex.solomon.yasm.expression.grammar.YasmSelRenderer;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class Perc implements FunctionRenderer {

    @Override
    public String name() {
        return "perc";
    }

    @Override
    public ExpressionWithConstants render(YasmSelRenderer renderer, List<YasmAst> args) {
        if (args.size() != 2) {
            throw new IllegalArgumentException("Expected 2 arguments for perc call, got: " + args.size());
        }
        ExpressionWithConstants arg0 = renderer.visit(args.get(0));
        ExpressionWithConstants arg1 = renderer.visit(args.get(1));
        AstBinOp result = new AstBinOp(PositionRange.UNKNOWN,
                new AstValueDouble(PositionRange.UNKNOWN, 100d),
                new AstBinOp(PositionRange.UNKNOWN,
                        arg0.expression,
                        arg1.expression,
                        new AstOp(PositionRange.UNKNOWN, "/")),
                new AstOp(PositionRange.UNKNOWN, "*"));
        return ExpressionWithConstants.of(result, List.of(arg0.constants, arg1.constants), arg0.scalar && arg1.scalar);
    }
}
