package ru.yandex.solomon.yasm.expression.grammar.functions;

import java.util.List;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.PositionRange;
import ru.yandex.solomon.expression.ast.Ast;
import ru.yandex.solomon.expression.ast.AstCall;
import ru.yandex.solomon.expression.ast.AstIdent;
import ru.yandex.solomon.yasm.expression.ast.YasmAst;
import ru.yandex.solomon.yasm.expression.grammar.ExpressionWithConstants;
import ru.yandex.solomon.yasm.expression.grammar.FunctionRenderer;
import ru.yandex.solomon.yasm.expression.grammar.YasmSelRenderer;

import static ru.yandex.solomon.yasm.expression.grammar.functions.Const.makeLineArg;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class Sum implements FunctionRenderer {
    @Override
    public String name() {
        return "sum";
    }

    @Override
    public ExpressionWithConstants render(YasmSelRenderer renderer, List<YasmAst> args) {
        if (args.size() < 1) {
            throw new IllegalArgumentException("Expected at least 1 argument for sum, got: " + args.size());
        }
        List<ExpressionWithConstants> renderedArgs = args.stream()
                .map(arg -> makeLineArg(renderer, arg))
                .collect(Collectors.toList());
        List<Ast> groupArgs = renderedArgs.stream().map(exp -> exp.expression).collect(Collectors.toList());
        return ExpressionWithConstants.series(
                new AstCall(PositionRange.UNKNOWN, new AstIdent(PositionRange.UNKNOWN, "series_sum"), List.of(
                        new AstCall(PositionRange.UNKNOWN, new AstIdent(PositionRange.UNKNOWN, "flatten"),
                                groupArgs))),
                renderedArgs.stream().map(exp -> exp.constants).collect(Collectors.toList()));
    }
}
