package ru.yandex.solomon.yasm.expression.grammar.functions;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.PositionRange;
import ru.yandex.solomon.expression.ast.AstCall;
import ru.yandex.solomon.expression.ast.AstIdent;
import ru.yandex.solomon.yasm.expression.ast.YasmAst;
import ru.yandex.solomon.yasm.expression.grammar.ExpressionWithConstants;
import ru.yandex.solomon.yasm.expression.grammar.FunctionRenderer;
import ru.yandex.solomon.yasm.expression.grammar.YasmSelRenderer;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class UnaryFunc implements FunctionRenderer {
    private final String name;

    public UnaryFunc(String name) {
        this.name = name;
    }

    @Override
    public String name() {
        return name;
    }

    @Override
    public ExpressionWithConstants render(YasmSelRenderer renderer, List<YasmAst> args) {
        if (args.size() != 1) {
            throw new IllegalArgumentException("Expected 1 argument for " + name + ", got: " + args.size());
        }
        return renderer.visit(args.get(0)).map(expression -> new AstCall(PositionRange.UNKNOWN,
                        new AstIdent(PositionRange.UNKNOWN, name),
                        List.of(expression)));
    }
}
