grammar Yasm;

input : expression EOF
      ;

expression : IDENT
           | IDENT '(' args ')'
           ;

args :
     | arg
     | args ',' arg
     ;

arg : NUMBER
    | expression
    ;

NUMBER : [-+]? [0-9]+ ('.' [0-9]*)? ([eE][-+]?[0-9]+)?;
IDENT : [a-zA-Z\-<*] [a-zA-Z0-9_\-./@<|>*]* ;
WS : [ \t\r\n]+ -> skip ;
