package ru.yandex.solomon.kikimr;

import org.apache.commons.lang3.SystemUtils;


/**
 * Enumerates all the platforms on which Kikimr can be launched.
 *
 * @author snoop
 */
public enum KikimrPlatform {
    MAC,
    LINUX,
    ;

    public static final KikimrPlatform CURRENT = getCurrent();

    private static KikimrPlatform getCurrent() {
        if (SystemUtils.IS_OS_MAC_OSX) {
            return KikimrPlatform.MAC;
        }
        if (SystemUtils.IS_OS_LINUX) {
            return KikimrPlatform.LINUX;
        }
        throw new IllegalStateException("Unsupported platform " + SystemUtils.OS_NAME + " for KiKiMR");
    }
}
