package ru.yandex.solomon.kikimr;

import java.util.Map;

import static ru.yandex.solomon.kikimr.KikimrPlatform.LINUX;
import static ru.yandex.solomon.kikimr.KikimrPlatform.MAC;


/**
 * @author Vladimir Gordiychuk
 */
public enum KikimrVersion {
    /** Release stable-20-4-42 */
    V20_4_42(Map.of(LINUX, 1985274150L, MAC, 1985274980L), "stable-20-4-42"),

    /** Release stable-20-6-10 */
    V20_6_10(Map.of(LINUX, 1985893357L, MAC, 1985892669L), "stable-20-6-10"),

    /** Release stable-22-2-31 */
    V22_2_31(Map.of(LINUX, 3079184288L, MAC, 3079182374L), "stable-22-2-31"),

    /** Release stable-22-2-49 */
    V22_2_49(Map.of(LINUX, 3317989765L, MAC, 3317989399L), "stable-22-2-49"),
    ;

    /**
     * Latest stable version
     */
    public static final KikimrVersion LATEST = V22_2_49; // Keep solomon/libs/java/ydb.inc in sync

    private final Map<KikimrPlatform, Long> resourceByPlatform;
    private final String tagName;

    KikimrVersion(Map<KikimrPlatform, Long> resourceByPlatform, String tagName) {
        this.resourceByPlatform = resourceByPlatform;
        this.tagName = tagName;
    }

    public Long getSandboxResourceIdFor(KikimrPlatform platform) {
        return resourceByPlatform.get(platform);
    }

    public String getTagName() {
        return tagName;
    }
}
