package ru.yandex.solomon.kikimr;

import java.nio.file.Path;
import java.util.UUID;

import com.yandex.ydb.core.grpc.GrpcTransport;
import com.yandex.ydb.table.SchemeClient;
import com.yandex.ydb.table.TableClient;
import com.yandex.ydb.table.rpc.grpc.GrpcSchemeRpc;
import com.yandex.ydb.table.rpc.grpc.GrpcTableRpc;


/**
 * @author Sergey Polovko
 */
public final class YdbHelper implements AutoCloseable {

    private final GrpcTransport transport;
    private final TableClient tableClient;
    private final SchemeClient schemeClient;
    private final Path rootPath;

    public YdbHelper(LocalKikimr localKikimr, String testName) {
        this.transport = GrpcTransport.forHosts(localKikimr.getGrpcEndpoint())
            .build();

        this.tableClient = TableClient.newClient(GrpcTableRpc.useTransport(transport))
            .sessionPoolSize(50, 200)
            .build();
        this.schemeClient = SchemeClient.newClient(GrpcSchemeRpc.useTransport(transport)).build();

        this.rootPath = localKikimr.getRoot()
            .resolve(UUID.randomUUID().toString())
            .resolve(testName);

        schemeClient.makeDirectories(rootPath.toString())
            .join()
            .expect("cannot create dirs: " + rootPath.toString());
    }

    public TableClient getTableClient() {
        return tableClient;
    }

    public SchemeClient getSchemeClient() {
        return schemeClient;
    }

    public String getRootPath() {
        return rootPath.toString();
    }

    public String resolvePath(String name) {
        return rootPath.resolve(name).toString();
    }

    @Override
    public void close() {
        schemeClient.close();
        tableClient.close();
        transport.close();
    }
}
