package ru.yandex.solomon.ydb;

import org.apache.commons.lang3.StringUtils;

/**
 * @author Vladimir Gordiychuk
 */
public class YdbEndpoint {

    private static final String SCHEME_GRPC = "grpc://";
    private static final String SCHEME_GRPCS = "grpcs://";

    public static boolean isSecure(String endpoint) {
        return endpoint.startsWith(SCHEME_GRPCS);
    }

    public static String removeScheme(String endpoint) {
        if (isSecure(endpoint)) {
            return StringUtils.removeStart(endpoint, SCHEME_GRPCS);
        } else {
            return StringUtils.removeStart(endpoint, SCHEME_GRPC);
        }
    }
}
