package ru.yandex.solomon.ydb;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

import com.yandex.ydb.table.result.ResultSetReader;

/**
 * @author Vladimir Gordiychuk
 */
public interface YdbResultSetConsumer extends Consumer<ResultSetReader> {
    /**
     * Calls before start streaming ResultSets to consumer.
     * In case of retry from the beginning method can be called multiple times.
     */
    default void restart() {}

    /**
     * @return completed future if consumer ready to accept next sequence of ResultSet's
     */
    default CompletableFuture<Void> readyFuture() {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    void accept(ResultSetReader resultSet);
}
