package ru.yandex.solomon.ydb;

import java.time.Instant;

import com.google.protobuf.ByteString;
import com.google.protobuf.UnsafeByteOperations;
import com.yandex.ydb.table.result.ResultSetReader;

/**
 * @author Vladimir Gordiychuk
 */
public class YdbResultSets {
    public static String utf8(ResultSetReader rs, int idx) {
        return rs.getColumn(idx).getUtf8();
    }

    public static Instant timestamp(ResultSetReader rs, int idx) {
        return rs.getColumn(idx).getTimestamp();
    }

    public static int uint8(ResultSetReader rs, int idx) {
        return Math.toIntExact(rs.getColumn(idx).getUint8());
    }

    public static int uint32(ResultSetReader rs, int idx) {
        return Math.toIntExact(rs.getColumn(idx).getUint32());
    }

    public static long uint64(ResultSetReader rs, int idx) {
        return rs.getColumn(idx).getUint64();
    }

    public static ByteString bytes(ResultSetReader rs, int idx) {
        return UnsafeByteOperations.unsafeWrap(rs.getColumn(idx).getString());
    }
}
