package ru.yandex.solomon.ydb;

import com.yandex.ydb.table.TableClient;
import com.yandex.ydb.table.stats.SessionPoolStats;

import ru.yandex.monlib.metrics.MetricConsumer;
import ru.yandex.monlib.metrics.MetricSupplier;
import ru.yandex.monlib.metrics.MetricType;
import ru.yandex.monlib.metrics.labels.Labels;

/**
 * @author Sergey Polovko
 */
public class YdbTableClientMetrics implements MetricSupplier {
    private final TableClient tableClient;
    private final String clientName;

    public YdbTableClientMetrics(TableClient tableClient, String clientName) {
        this.tableClient = tableClient;
        this.clientName = clientName;
    }

    @Override
    public int estimateCount() {
        return 5; // keep in sync with number of metrics in append() method
    }

    @Override
    public void append(long tsMillis, Labels commonLabels, MetricConsumer consumer) {
        SessionPoolStats stats = tableClient.getSessionPoolStats();
        gauge(tsMillis, commonLabels, consumer, "ydb.sessionPool.minSize", stats.getMinSize());
        gauge(tsMillis, commonLabels, consumer, "ydb.sessionPool.maxSize", stats.getMaxSize());
        gauge(tsMillis, commonLabels, consumer, "ydb.sessionPool.idle", stats.getIdleCount());
        gauge(tsMillis, commonLabels, consumer, "ydb.sessionPool.disconnected", stats.getDisconnectedCount());
        gauge(tsMillis, commonLabels, consumer, "ydb.sessionPool.acquired", stats.getAcquiredCount());
        gauge(tsMillis, commonLabels, consumer, "ydb.sessionPool.pendingAcquire", stats.getPendingAcquireCount());
    }

    private void gauge(long tsMillis, Labels commonLabels, MetricConsumer consumer, String name, long value) {
        consumer.onMetricBegin(MetricType.IGAUGE);
        consumer.onLabelsBegin(commonLabels.size() + 1);
        commonLabels.forEach(consumer::onLabel);
        consumer.onLabel("sensor", name);
        consumer.onLabel("clientName", clientName);
        consumer.onLabelsEnd();
        consumer.onLong(tsMillis, value);
        consumer.onMetricEnd();
    }
}
