package ru.yandex.solomon.ydb.page;

/**
 * @author Sergey Polovko
 */
public class PageOptions {

    public static final int DEFAULT_SIZE = 30;
    public static final int ALL_SIZE = -1;

    public static PageOptions MAX = new PageOptions(1000, 0);
    public static PageOptions ALL = new PageOptions(ALL_SIZE, 0);

    private final int size;
    private final int current;


    public PageOptions(int size, int current) {
        this.size = size;
        this.current = current;
    }

    public int getSize() {
        return size;
    }

    public int getCurrent() {
        return current;
    }

    public int getOffset() {
        return current * size;
    }

    public boolean isLimited() {
        return size != ALL_SIZE;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        PageOptions that = (PageOptions) o;

        if (size != that.size) return false;
        return current == that.current;
    }

    @Override
    public int hashCode() {
        int result = size;
        result = 31 * result + current;
        return result;
    }

    @Override
    public String toString() {
        return "PageOptions{" +
            "size=" + size +
            ", current=" + current +
            '}';
    }
}
