package ru.yandex.solomon.ydb.page;

import java.io.IOException;
import java.io.UncheckedIOException;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.BaseEncoding;

/**
 * @author Stanislav Kashirin
 */
public final class PageTokenCodec<T> {

    private static final ObjectMapper mapper = new ObjectMapper();

    private final Class<T> tokenType;

    private PageTokenCodec(Class<T> tokenType) {
        this.tokenType = tokenType;
    }

    public static <T> PageTokenCodec<T> forType(Class<T> tokenType) {
        return new PageTokenCodec<>(tokenType);
    }

    public String encode(T tokenParts) {
        try {
            var json = mapper.writeValueAsBytes(tokenParts);
            return BaseEncoding.base64Url().encode(json);
        } catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public T decode(CharSequence token) {
        try {
            var json = BaseEncoding.base64Url().decode(token);
            return mapper.readValue(json, tokenType);
        } catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }
}
