package ru.yandex.solomon.ydb.page;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class TokenPageOptions {

    private final int pageSize;
    private final String pageToken;

    public TokenPageOptions(int pageSize, String pageToken) {
        final int finalPageSize;
        if (pageSize <= 0) {
            finalPageSize = 100;
        } else {
            finalPageSize = Math.min(pageSize, 1000);
        }

        this.pageSize = finalPageSize;
        this.pageToken = pageToken;
    }

    public int getSize() {
        return pageSize;
    }

    public int getOffset() {
        return pageToken.isEmpty() ? 0 : Integer.parseInt(pageToken);
    }

    public String getPageToken() {
        return pageToken;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        TokenPageOptions that = (TokenPageOptions) o;

        if (pageSize != that.pageSize) {
            return false;
        }
        return pageToken.equals(that.pageToken);
    }

    @Override
    public int hashCode() {
        int result = pageSize;
        result = 31 * result + pageToken.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "TokenPageOptions{" +
            "pageSize=" + pageSize +
            ", pageToken='" + pageToken + '\'' +
            '}';
    }
}
