package ru.yandex.solomon.ydb;

import org.junit.Test;

import ru.yandex.solomon.config.IamKeyJson;

import static org.junit.Assert.assertEquals;

/**
 * @author Sergey Polovko
 */
public class IamKeyJsonTest {

    @Test
    public void parse() {
        String json = """
                {
                    "id": "ajeh4pgu9i46trmcqa6v",
                    "service_account_id": "yc.monitoring.alerting-sa",
                    "created_at": "2021-01-12T22:09:36.591995Z",
                    "key_algorithm": "RSA_2048",
                    "public_key": "PUBLIC KEY",
                    "private_key": "PRIVATE KEY"
                }
                """;

        IamKeyJson key = IamKeyJson.parseFromJson(json);
        assertEquals("ajeh4pgu9i46trmcqa6v", key.getId());
        assertEquals("yc.monitoring.alerting-sa", key.getAccountId());
        assertEquals("PRIVATE KEY", key.getPrivateKey());
    }
}
