package ru.yandex.solomon.ydb;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;

import javax.annotation.Nullable;

import com.yandex.ydb.table.result.ResultSetReader;

/**
 * @author Vladimir Gordiychuk
 */
public class YdbResultSetConsumerStub implements YdbResultSetConsumer {
    public final ArrayBlockingQueue<ResultSetReader> resultSets;
    public volatile CompletableFuture<Void> readyFuture = CompletableFuture.completedFuture(null);
    @Nullable
    public volatile Runnable before;
    @Nullable
    public volatile Runnable after;

    public YdbResultSetConsumerStub(int capacity) {
        resultSets = new ArrayBlockingQueue<>(capacity);
    }

    @Override
    public CompletableFuture<Void> readyFuture() {
        return readyFuture;
    }

    @Override
    public void accept(ResultSetReader resultSet) {
        call(before);
        try {
            resultSets.put(resultSet);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        call(after);
    }

    private void call(@Nullable Runnable runnable) {
        if (runnable != null) {
            runnable.run();
        }
    }
}
