package ru.yandex.solomon.co2;

import java.util.concurrent.ConcurrentLinkedQueue;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.misc.cmdline.CmdArgsChief;

/**
 * @author Maksim Leonov (nohttp@)
 */
public class Main {
    public static void main(String[] args) {
        CmdlineConfig cc = new CmdlineConfig();
        CmdArgsChief cmdArgsChief = new CmdArgsChief(cc, Cf.x(args));

        ConcurrentLinkedQueue<MetricMessage> messageQueue = new ConcurrentLinkedQueue<>();

        Co2 monitor = new Co2(messageQueue);
        Pusher pusher = new Pusher(cc, messageQueue);

        try {
            monitor.run();
        } catch (InterruptedException e) {
            pusher.stop();
            System.exit(1);
        }
    }
}
