package ru.yandex.solomon.experiments.alexlovkov;

/**
 * @author alexlovkov
 */
public class Node implements Comparable<Node> {

    private String metric;
    private long count;

    public Node(String metric, long count) {
        this.metric = metric;
        this.count = count;
    }

    public String getMetric() {
        return metric;
    }

    public long getCount() {
        return count;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Node node = (Node) o;

        if (count != node.count) return false;
        return metric != null ? metric.equals(node.metric) : node.metric == null;
    }

    @Override
    public int hashCode() {
        int result = metric != null ? metric.hashCode() : 0;
        result = 31 * result + (int) (count ^ (count >>> 32));
        return result;
    }

    @Override
    public int compareTo(Node o) {
        return Long.compare(o.count, count);
    }
}
