package ru.yandex.solomon.experiments.alexlovkov;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;


/**
 * @author alexlovkov
 **/
public class SortMetrics {

    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.out.println("expect 2 params: inputFile & outputFile");
            return;
        }
        String fileName = args[0];
        String outputFileName = args[1];
        long start = System.currentTimeMillis();
        System.out.println("Started");
        List<String> lines = Files.readAllLines(Paths.get(fileName));
        System.out.println("read for:" + (System.currentTimeMillis() - start));

        start = System.currentTimeMillis();
        lines.sort((o1, o2) -> {
            int h1 = o1.hashCode();
            int h2 = o2.hashCode();
            if (h1 != h2) {
                return Integer.compare(h1, h2);
            }
            return o1.compareTo(o2);
        });
        System.out.println("sorted for:" + (System.currentTimeMillis() - start));

        Path path = Paths.get(outputFileName);
        try {
            Files.delete(path);
        } catch (Throwable t) {
        }

        System.out.println("Started write output");
        start = System.currentTimeMillis();
        Files.write(path, lines);
        System.out.println("wrote for:" + (System.currentTimeMillis() - start));
    }
}
