package ru.yandex.solomon.experiments.alexlovkov;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;

/**
 * @author alexlovkov
 */
public class TrieAnalyzer {

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.err.println("require file with metrics");
            System.exit(1);
        }
        String file = args[0];
        System.out.println("Started trieAnalyze");
        List<String> strings = Files.readAllLines(Paths.get(file));

        Trie trie = new Trie();
        System.out.println("started building trie");

        for (String s : strings) {
            trie.insert(s.split("\\."));
        }
//        System.out.println("trie completed");
//              trie.analyze();
        wandering(trie);
    }

    private static void wandering(Trie trie) {
        BufferedReader reader =
            new BufferedReader(new InputStreamReader(System.in));
        for (; ; ) {
            List<Node> children = trie.getChildren();
            Collections.sort(children);
            boolean cutted = false;
            int realSize = children.size();
            if (children.size() > 30) {
                children = children.subList(0, 30);
                cutted = true;
            }
            for (Node node : children) {
                System.err.println(String.format("%-8s%s", node.getCount(), node.getMetric()));
            }
            if (cutted) {
                System.out.println("results were cut, actual size was:" + realSize);
            }

            try {
                String command = reader.readLine();
                if ("..".equals(command)) {
                    trie.goToParent();
                } else {
                    trie.goToChild(command);
                }
            } catch (Throwable e) {
                System.out.println(e.getMessage());
            }
        }

    }
}
