package ru.yandex.solomon.experiments.alextrushkin;

import java.util.concurrent.Executor;

import io.grpc.CallCredentials;
import io.grpc.Metadata;

import ru.yandex.solomon.auth.AuthType;

/**
 * @author Alexey Trushkin
 */
public class AuthCallCredentials extends CallCredentials {
    private final AuthType type;
    private final String token;

    private AuthCallCredentials(AuthType type, String token) {
        this.type = type;
        this.token = token;
    }

    public static AuthCallCredentials asUser(String login) {
        return new AuthCallCredentials(AuthType.AsUser, login);
    }

    public static AuthCallCredentials oAuth(String token) {
        return new AuthCallCredentials(AuthType.OAuth, token);
    }

    public static AuthCallCredentials iam(String token) {
        return new AuthCallCredentials(AuthType.IAM, token);
    }

    @Override
    public void applyRequestMetadata(
            RequestInfo requestInfo,
            Executor appExecutor,
            MetadataApplier applier)
    {
        Metadata headers = new Metadata();
        String value;
        if (type.getValuePrefix().isEmpty()) {
            value = token;
        } else {
            value = type.getValuePrefix() + token;
        }

        headers.put(type.getMetadataKey(), value);

        applier.apply(headers);
    }

    @Override
    public void thisUsesUnstableApi() {
    }
}
