package ru.yandex.solomon.experiments.alextrushkin;

import java.io.File;
import java.util.Map;

import javax.net.ssl.SSLException;

import io.grpc.ManagedChannel;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyChannelBuilder;

import ru.yandex.monitoring.api.v3.CreateResourceRequest;
import ru.yandex.monitoring.api.v3.DeleteResourceRequest;
import ru.yandex.monitoring.api.v3.GetResourceRequest;
import ru.yandex.monitoring.api.v3.ListResourcesRequest;
import ru.yandex.monitoring.api.v3.Operation;
import ru.yandex.monitoring.api.v3.ServiceProviderResourceId;
import ru.yandex.monitoring.api.v3.ServiceProviderResourceServiceGrpc;
import ru.yandex.monitoring.api.v3.UpdateResourceRequest;

/**
 * @author Alexey Trushkin
 */
public class ResourcesClient {

    public static void main(String[] args) throws Exception {
        AuthCallCredentials credentials = AuthCallCredentials.asUser("alextrushkin");
        var channel = localChannel();
        var client = ServiceProviderResourceServiceGrpc.newBlockingStub(channel).withCallCredentials(credentials);

        Operation operation = null;
        operation = client.create(CreateResourceRequest.newBuilder()
                .setAbcSlug("alextrushkin_test1")
                //  .setProjectId("alextrushkin_test12")
                .setName("name1")
                .setServiceProviderId("managed-postgresql")
                .setType("my_type")
                .setResourceId("xcvxc")
                .putAllResourceComplexId(Map.of("cluster", "hahn", "account", "solomon"))
                .build());
        if (operation.hasError()) {
            throw new IllegalArgumentException(operation.getError().getMessage());
        }
        System.out.println(operation);
        operation = client.create(CreateResourceRequest.newBuilder()
                .setAbcSlug("alextrushkin_test1")
                //   .setProjectId("alextrushkin_test1")
                .setName("name1")
                .setServiceProviderId("managed-postgresql")
                .setType("my_type")
                .setResourceId("asaf")
                .putAllResourceComplexId(Map.of("cluster", "hahn", "account", "solomon"))
                .build());
        if (operation.hasError()) {
            throw new IllegalArgumentException(operation.getError().getMessage());
        }
        System.out.println(operation);


       /* var res = client.get(GetResourceRequest.newBuilder()
                .setAbcSlug("solomon")
                .setId(ServiceProviderResourceId.newBuilder()
                        .setComplexId(ServiceProviderResourceId.ComplexId.newBuilder()
                                .setServiceProviderId("managed-postgresql")
                                .putAllResourceComplexId(Map.of("cluster", "hahn", "account", "solomon"))
                                .build())
                        .build())
                .build());
        System.out.println(res);

        var res = client.get(GetResourceRequest.newBuilder()
                .setAbcSlug("solomon")
                .setId(ServiceProviderResourceId.newBuilder()
                        .setResourceId("123")
                        .build())
                .build());
        System.out.println(res);*/
        var res = client.get(GetResourceRequest.newBuilder()
                .setAbcSlug("solomon")
                .setId(ServiceProviderResourceId.newBuilder()
                        .setResourceId("1234567")
                        .build())
                .build());
        System.out.println(res);
        operation = client.update(UpdateResourceRequest.newBuilder()
                .setAbcSlug("solomon")
                .setId(ServiceProviderResourceId.newBuilder()
                        .setResourceId("1234567")
                        .build())
                .setName("name2")
                .setType("type2")
                .setProjectId("alextrushkin_test2")
                .build());
        if (operation.hasError()) {
            throw new IllegalArgumentException(operation.getError().getMessage());
        }
        System.out.println(operation);
        res = client.get(GetResourceRequest.newBuilder()
                .setAbcSlug("solomon")
                .setId(ServiceProviderResourceId.newBuilder()
                        .setResourceId("1234567")
                        .build())
                .build());
        System.out.println(res);

        var list = client.list(ListResourcesRequest.newBuilder().setAbcSlug("solomon").build());
        System.out.println(list);

        operation = client.delete(DeleteResourceRequest.newBuilder()
                .setAbcSlug("solomon")
                .setId(ServiceProviderResourceId.newBuilder()
                        .setResourceId("1234567")
                        .build())
                .build());
        if (operation.hasError()) {
            throw new IllegalArgumentException(operation.getError().getMessage());
        }

        list = client.list(ListResourcesRequest.newBuilder().setAbcSlug("solomon").build());
        System.out.println(list);

        res = client.get(GetResourceRequest.newBuilder()
                .setAbcSlug("solomon")
                .setId(ServiceProviderResourceId.newBuilder()
                        .setResourceId("1234567")
                        .build())
                .build());
        System.out.println(res);
    }

    private static ManagedChannel localChannel() {
        return NettyChannelBuilder.forTarget("localhost:5740")
                .negotiationType(NegotiationType.PLAINTEXT)
                .build();
    }


    private static ManagedChannel remoteChannel(String address) throws SSLException {
        if (address.isBlank()) {
            address = "solomon-pre.yandex-team.ru:443";
        }
        var sslContext = GrpcSslContexts.forClient().trustManager(new File("/Users/alextrushkin/arcadia/certs/cacert.pem")).build();
        return NettyChannelBuilder.forTarget(address)
                .negotiationType(NegotiationType.TLS)
                .sslContext(sslContext)
                .build();
    }
}
