package ru.yandex.solomon.experiments.alextrushkin;

import java.util.concurrent.ForkJoinPool;

import com.fasterxml.jackson.databind.ObjectMapper;

import ru.yandex.solomon.core.db.dao.ClustersDao;
import ru.yandex.solomon.core.db.dao.ServicesDao;
import ru.yandex.solomon.core.db.dao.ShardsDao;
import ru.yandex.solomon.core.db.dao.ydb.YdbClustersDao;
import ru.yandex.solomon.core.db.dao.ydb.YdbServicesDao;
import ru.yandex.solomon.core.db.dao.ydb.YdbShardsDao;
import ru.yandex.solomon.core.db.model.Cluster;
import ru.yandex.solomon.core.db.model.Service;
import ru.yandex.solomon.core.db.model.Shard;
import ru.yandex.solomon.tool.YdbClient;
import ru.yandex.solomon.tool.YdbHelper;
import ru.yandex.solomon.tool.cfg.SolomonCluster;

/**
 * @author Alexey Trushkin
 */
public class UpdateShardSettingsCli implements AutoCloseable {

    private final YdbClient ydb;
    private final ServicesDao serviceDao;
    private final ShardsDao shardDao;
    private final ClustersDao clustersDao;


    public UpdateShardSettingsCli(SolomonCluster cluster) {
        this.ydb = YdbHelper.createYdbClient(cluster);
        var mapper = new ObjectMapper();
        serviceDao = new YdbServicesDao(ydb.table, cluster.kikimrRootPath() + "/Config/V2/Service", mapper, ForkJoinPool.commonPool());
        shardDao = new YdbShardsDao(ydb.table, cluster.kikimrRootPath() + "/Config/V2/Shard", mapper, ForkJoinPool.commonPool());
        clustersDao = new YdbClustersDao(ydb.table, cluster.kikimrRootPath() + "/Config/V2/Cluster", mapper, ForkJoinPool.commonPool());
    }

    public static void main(String[] args) {
        try (var cli = new UpdateShardSettingsCli(SolomonCluster.TEST_FRONT)) {
            cli.updateShardSettings();
        } catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    private void updateShardSettings() {
        var services = serviceDao.findAll().join();
        for (Service service : services) {
            while (serviceDao.partialUpdate(service).join().isEmpty()) {
                var getOptional = serviceDao.findOne(service.getProjectId(), service.getFolderId(), service.getId()).join();
                if (getOptional.isPresent()) {
                    service = getOptional.get();
                } else {
                    break;
                }
            }
        }

        var clusters = clustersDao.findAll().join();
        for (Cluster cluster : clusters) {
            while (clustersDao.partialUpdate(cluster).join().isEmpty()) {
                var getOptional = clustersDao.findOne(cluster.getProjectId(), "", cluster.getId()).join();
                if (getOptional.isPresent()) {
                    cluster = getOptional.get();
                } else {
                    break;
                }
            }
        }

        var shards = shardDao.findAll().join();
        for (Shard shard : shards) {
            while (shardDao.partialUpdate(shard, false).join().isEmpty()) {
                var getOptional = shardDao.findOne(shard.getProjectId(), shard.getFolderId(), shard.getId()).join();
                if (getOptional.isPresent()) {
                    shard = getOptional.get();
                } else {
                    break;
                }
            }
        }
    }

    @Override
    public void close() {
        ydb.close();
    }
}
