package ru.yandex.solomon.experiments.benchmark;

import java.util.concurrent.TimeUnit;

import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

import ru.yandex.solomon.model.point.AggrPoint;
import ru.yandex.solomon.model.point.RecyclableAggrPoint;

/**
 * @author Vladimir Gordiychuk
 */
@Fork(value = 1)
@Measurement(iterations = 10, time = 3, timeUnit = TimeUnit.SECONDS)
@Warmup(iterations = 5, time = 3, timeUnit = TimeUnit.SECONDS)
@State(Scope.Thread)
@Threads(1) //current test not support concurrent execution
@BenchmarkMode(Mode.Throughput)
@OutputTimeUnit(TimeUnit.MILLISECONDS)
public class AggrPointJmhBenchmark {

    /*

Benchmark                           Mode  Cnt       Score       Error   Units
AggrPointJmhBenchmark.create       thrpt   10   68826.227 ±  4227.492  ops/ms
AggrPointJmhBenchmark.fast         thrpt   10  154936.651 ±  9953.924  ops/ms
AggrPointJmhBenchmark.threadLocal  thrpt   10  222423.967 ± 13946.076  ops/ms

     */

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder()
            .include(AggrPointJmhBenchmark.class.getName())
            .detectJvmArgs()
            .jvmArgs("-Xmx3g", "-Xms3g")
            .build();

        new Runner(opt).run();
    }

    @Benchmark
    public Object create() {
        return new AggrPoint();
    }

    @Benchmark
    public Object threadLocal() {
        return RecyclableAggrPoint.newInstance();
    }

//    @Benchmark
//    public Object fast() {
//        return AggrPoint.fastThreadPoint.get();
//    }

}
