package ru.yandex.solomon.experiments.egorlitvinenk;

import java.io.IOException;
import java.util.concurrent.TimeUnit;

import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

import ru.yandex.monlib.metrics.labels.Label;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.coremon.meta.db.ydb.LabelListSortedSerialize;
import ru.yandex.solomon.util.Escaper;

/**
 *
 * @author Egor Litvinenko
 */
@Fork(value = 2)
@Measurement(iterations = 5, time = 5, timeUnit = TimeUnit.SECONDS)
@Warmup(iterations = 3, time = 2, timeUnit = TimeUnit.SECONDS)
@State(Scope.Thread)
@Threads(4)
@BenchmarkMode(Mode.All)
@OutputTimeUnit(TimeUnit.MILLISECONDS)
public class LabelsToStringBenchmark {
    @Param({
            "&ctype=toloka-6398&geo=myt&group=QLOUD_GOLOVAN_MYT.5.1&host=/SELF&prj=toloka&signal=unistat-hystrix.blackbox.oauth.latencyTotal_percentile_99.gauge_ahhh&tier=tqms-analytics-1&",
            "&ctype=/SELF&geo=/SELF&group=VLA.001.0&host=/SELF&prj=/SELF&signal=balancer_report-report-delivery-pr-13009-favicon-4xx-internalrobot_summ&tier=/SELF&",
            "&bin=16000&category=app&database=/global/ycloud&host=ycloud-dn-vla8&sensor=DataShard/TxProgressExecLatency&slot=static&type=DataShard&",
            "&host=sas4-4969&network=seneca-sas-backbone&sensor=yt.bus.out_bytes.rate&",
            "&aggregation=avg&host=sas0-9091&sensor=yt.resource_tracker.user_cpu&thread=DelayedPoller&",
            "&host=vla1-8782&metric_name=yt/location/split_changelogs/changelog_truncate_io_time&sensor=yt.solomon_registry.cube_size&yt_aggr=1&",
            "&ctype=production&geo=rad&group=CON_MYT.1.0&host=/SELF&prj=kalproxy-playlist&signal=instances-discarded_instances_tmmm&tier=rt-hd&"
    })
    public String labelSet;
    public Labels labels;


    @Setup(Level.Invocation)
    public void setUp() throws IOException {
        labels = LabelListSortedSerialize.parse(labelSet);
    }

    @Benchmark
    public String LabelsToStringSortedSerialize(LabelsToStringBenchmark benchmark) {
        return LabelListSortedSerialize.format(benchmark.labels);
    }

    @Benchmark
    public String explicitToString(LabelsToStringBenchmark benchmark) {
        StringBuilder result = new StringBuilder(256);
        result.append('&');
        for (int i = 0; i < benchmark.labels.size(); i++) {
            final var label = benchmark.labels.at(i);
            ESCAPER.escapeTo(label.getKey(), result);
            result.append('=');
            ESCAPER.escapeTo(label.getValue(), result);
            result.append('&');
        }
        return result.toString();
    }

    @Benchmark
    public String explicitToArray(LabelsToStringBenchmark benchmark) {
        StringBuilder result = new StringBuilder(256);
        result.append('&');
        Label[] labels1 = benchmark.labels.toArray();
        for (Label label : labels1) {
            ESCAPER.escapeTo(label.getKey(), result);
            result.append('=');
            ESCAPER.escapeTo(label.getValue(), result);
            result.append('&');
        }
        return result.toString();
    }

    static final String SENTINEL = "~"; // ord('~') = 126
    private static final char ESCAPE_CHAR = '\\';
    private static final Escaper ESCAPER = new Escaper("=&", ESCAPE_CHAR);

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder()
                .include(LabelsToStringBenchmark.class.getName())
                .detectJvmArgs()
                .jvmArgs("-Xmx1g", "-Xms1g", "--enable-preview")
//            .addProfiler(GCProfiler.class)
//            .addProfiler(FlightRecorderProfiler.class)
                .build();

        new Runner(opt).run();
    }

}
