package ru.yandex.solomon.experiments.gordiychuk;

import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;

import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

import ru.yandex.solomon.math.stat.ASAP;
import ru.yandex.solomon.model.timeseries.GraphData;
import ru.yandex.solomon.model.timeseries.GraphDataArrayList;

/**
 * @author Vladimir Gordiychuk
 */
@Fork(value = 1)
@Measurement(iterations = 10, time = 1, timeUnit = TimeUnit.SECONDS)
@Warmup(iterations = 5, time = 1, timeUnit = TimeUnit.SECONDS)
@State(Scope.Thread)
@Threads(1) //current test not support concurrent execution
@BenchmarkMode(Mode.AverageTime)
@OutputTimeUnit(TimeUnit.MICROSECONDS)
public class AsapBenchmark {

    @Param({"10", "100", "1000", "10000"})
    public int pointCount;

    public GraphData source;

    /*

Before:
Benchmark             (pointCount)  Mode  Cnt      Score      Error  Units
AsapBenchmark.smooth            10  avgt   10      3.554 ±    0.582  us/op
AsapBenchmark.smooth           100  avgt   10     75.666 ±   24.969  us/op
AsapBenchmark.smooth          1000  avgt   10    943.285 ±  363.101  us/op
AsapBenchmark.smooth         10000  avgt   10  13021.629 ± 2273.531  us/op

Now:
Benchmark             (pointCount)  Mode  Cnt     Score     Error  Units
AsapBenchmark.smooth            10  avgt   10     0.955 ±   0.050  us/op
AsapBenchmark.smooth           100  avgt   10    11.626 ±   0.927  us/op
AsapBenchmark.smooth          1000  avgt   10   141.712 ±   8.591  us/op
AsapBenchmark.smooth         10000  avgt   10  3370.802 ± 225.506  us/op

     */

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder()
                .include(AsapBenchmark.class.getName())
                .detectJvmArgs()
//                .addProfiler(AsyncProfiler.class)
                .build();

        new Runner(opt).run();
    }

    @Setup
    public void setUp() {
        long ts0 = System.currentTimeMillis();
        ThreadLocalRandom random = ThreadLocalRandom.current();
        GraphDataArrayList list = new GraphDataArrayList(pointCount);
        for (int index = 0; index < pointCount; index++) {
            double value = random.nextDouble(0, 100);
            list.add(ts0 + (index * 15_000), value);
        }

        source = list.buildGraphDataFromSortedUniqueNoCheck();
    }

    @Benchmark
    public GraphData smooth() {
        return ASAP.smooth(source);
    }
}
