package ru.yandex.solomon.experiments.gordiychuk;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.profile.ExternalProfiler;
import org.openjdk.jmh.results.BenchmarkResult;
import org.openjdk.jmh.results.Result;

/**
 * @author Vladimir Gordiychuk
 */
public class AsyncProfiler implements ExternalProfiler {
    private static final String DEST = "/home/gordiychuk/junk/async-profile";

    @Override
    public Collection<String> addJVMInvokeOptions(BenchmarkParams params) {
        return Collections.emptyList();
    }

    @Override
    public Collection<String> addJVMOptions(BenchmarkParams params) {
        StringBuilder sb = new StringBuilder();
        for (String param : params.getParamsKeys()) {
            if (sb.length() != 0) {
                sb.append('-');
            }
            sb.append(param).append('-').append(params.getParam(param));
        }

        String target = DEST + "/" + params.getBenchmark() + "_" + sb + ".svg";

        List<String> opts = new ArrayList<>();
        opts.add("-XX:+UnlockDiagnosticVMOptions");
        opts.add("-XX:+DebugNonSafepoints");
        opts.add("-agentpath:/home/gordiychuk/project/open-source/async-profiler/build/libasyncProfiler.so=start,svg,file=" + target);
        System.out.println("Flamegraph: " + target);
        return opts;
    }

    @Override
    public void beforeTrial(BenchmarkParams benchmarkParams) {
    }

    @Override
    public Collection<? extends Result> afterTrial(BenchmarkResult br, long pid, File stdOut, File stdErr) {
        return Collections.emptyList();
    }

    @Override
    public boolean allowPrintOut() {
        return true;
    }

    @Override
    public boolean allowPrintErr() {
        return true;
    }

    @Override
    public String getDescription() {
        return "Collects flamegraph";
    }
}
