package ru.yandex.solomon.experiments.gordiychuk;

import java.util.concurrent.TimeUnit;

import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

import ru.yandex.solomon.codec.bits.BitBuf;
import ru.yandex.solomon.codec.bits.HeapBitBuf;

/**
 * @author Vladimir Gordiychuk
 */
@Fork(value = 1)
@Measurement(iterations = 20, batchSize = 30)
@Warmup(iterations = 10, batchSize = 30)
@State(Scope.Thread)
@Threads(1) //current test not support concurrent execution
@BenchmarkMode(Mode.AverageTime)
@OutputTimeUnit(TimeUnit.NANOSECONDS)
public class BitBufJmh2 {

    /*

Benchmark                    Mode  Cnt    Score    Error  Units
BitBufJmh2.writeIntVarint1N  avgt   20  401.519 ± 49.146  ns/op

Benchmark                    Mode  Cnt    Score    Error  Units
BitBufJmh2.writeIntVarint1N  avgt   20  223.179 ± 10.949  ns/op

Benchmark                  Mode  Cnt    Score   Error  Units
BitBufJmh2.writeBitsCount  avgt   20  240.150 ± 9.537  ns/op

Benchmark                  Mode  Cnt    Score   Error  Units
BitBufJmh2.writeBitsCount  avgt   20  214.211 ± 2.787  ns/op
     */

    private int value;
    private long longValue;
    private BitBuf bitBuf;

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder()
            .include(BitBufJmh2.class.getName())
            .detectJvmArgs()
            .jvmArgsAppend("-Dio.netty.buffer.checkBounds=true")
            .addProfiler(AsyncProfiler.class)
            .build();

        new Runner(opt).run();
    }

    @Setup
    public void prepare() {
        bitBuf = new HeapBitBuf(new byte[1024 << 20], 0); // 1024 Mib
    }

    @Setup(Level.Iteration)
    public void resetIndex() {
        bitBuf.resetWriterIndex();
        value = 5;
        longValue = 5;
    }

    @Benchmark
    public Object writeIntVarint1N() {
        bitBuf.writeIntVarint1N(value, 8);
        return bitBuf;
    }

    @Benchmark
    public Object writeBitsCount() {
        bitBuf.writeBits(value, 3);
        return bitBuf;
    }
}
