package ru.yandex.solomon.experiments.gordiychuk;

import ru.yandex.metabase.client.MetabaseClients;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.labels.protobuf.LabelConverter;
import ru.yandex.solomon.metabase.api.protobuf.CreateManyRequest;
import ru.yandex.solomon.metabase.api.protobuf.Metric;
import ru.yandex.solomon.model.protobuf.MetricType;
import ru.yandex.solomon.tool.cfg.SolomonCluster;
import ru.yandex.solomon.tool.cfg.SolomonPorts;

/**
 * @author Vladimir Gordiychuk
 */
public class ChangeMetricType {

    public static void main(String[] args) {
        var client = MetabaseClients.create(SolomonCluster.PRESTABLE_FETCHER.addresses(SolomonPorts.COREMON_GRPC));
        client.forceUpdateClusterMetaData().join();

        var req = CreateManyRequest.newBuilder()
            .addAllCommonLabels(LabelConverter.labelsToProtoList(Labels.of("project", "yasm_yasmtestit", "cluster", "group_0", "service", "yasm")))
            .addMetrics(Metric.newBuilder()
                .setType(MetricType.LOG_HISTOGRAM)
                .addAllLabels(LabelConverter.labelsToProtoList(Labels.of("signal", "push-agent_test_pushed_values_ahhh", "group", "QLOUD_GOLOVAN_MYT.5.0", "prj", "alovtsyus6")))
                .build())
            .build();

        var response = client.createMany(req).join();
        System.out.println("===request: ");
        System.out.println(req);
        System.out.println("===resp: ");
        System.out.println(response);
    }
}
