package ru.yandex.solomon.experiments.gordiychuk;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;

import com.fasterxml.jackson.databind.ObjectMapper;

import ru.yandex.solomon.core.validators.IdValidator;

/**
 * @author Vladimir Gordiychuk
 */
public class CheckMappingYasmITypeToProject {

    public static void main(String[] args) throws IOException, InterruptedException {
        var response = HttpClient.newHttpClient()
            .send(HttpRequest.newBuilder()
                .uri(URI.create("https://yasm.yandex-team.ru/metainfo/tags/itype"))
                .GET()
                .build(), HttpResponse.BodyHandlers.ofString());

        var mapper = new ObjectMapper();
        var node = mapper.readTree(response.body());

        for (var itype : node.get("response").get("result")) {
            System.out.println(itype.asText());
            IdValidator.ensureValid("yasm_" + itype.asText(), "itype");
        }
    }
}
