package ru.yandex.solomon.experiments.gordiychuk;

import java.util.concurrent.TimeUnit;

import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

import ru.yandex.misc.dataSize.DataSize;
import ru.yandex.solomon.codec.compress.CompressStreamFactory;
import ru.yandex.solomon.codec.compress.TimeSeriesOutputStream;
import ru.yandex.solomon.model.point.AggrPoint;
import ru.yandex.solomon.model.point.column.TsColumn;
import ru.yandex.solomon.model.point.column.ValueColumn;
import ru.yandex.solomon.model.protobuf.MetricType;

/**
 * @author Vladimir Gordiychuk
 */
@Fork(value = 1)
@Measurement(iterations = 20, batchSize = 30)
@Warmup(iterations = 10, batchSize = 30)
@State(Scope.Thread)
@Threads(1) //current test not support concurrent execution
@BenchmarkMode(Mode.AverageTime)
@OutputTimeUnit(TimeUnit.NANOSECONDS)
public class DoubleTimeseriesEncoderJmh {

    /*
Benchmark                         Mode  Cnt    Score    Error  Units
DoubleTimeseriesEncoderJmh.write  avgt   20  539.802 ± 19.164  ns/op

Benchmark                         Mode  Cnt    Score   Error  Units
DoubleTimeseriesEncoderJmh.write  avgt   20  459.887 ± 3.324  ns/op

     */

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder()
            .include(DoubleTimeseriesEncoderJmh.class.getName())
            .detectJvmArgs()
            .jvmArgsAppend("-Dio.netty.buffer.checkBounds=true")
            .addProfiler(AsyncProfiler.class)
            .build();

        new Runner(opt).run();
    }

    private int mask;
    private AggrPoint point;
    private TimeSeriesOutputStream ts;

    @Setup(Level.Iteration)
    public void resetIndex() {
        mask = TsColumn.mask | ValueColumn.mask;
        point = new AggrPoint(mask);
        point.tsMillis = System.currentTimeMillis();
        point.valueNum = 10;
        ts = CompressStreamFactory.createOutputStream(MetricType.DGAUGE, mask);
        ts.ensureCapacity((int) DataSize.fromMegaBytes(50).toBytes());
    }

    @Benchmark
    public Object write() {
        point.tsMillis += 15_000;
        ts.writePoint(mask, point);
        return ts;
    }
}
