package ru.yandex.solomon.experiments.gordiychuk;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;

import ru.yandex.solomon.tool.KikimrHelper;
import ru.yandex.solomon.tool.cfg.SolomonCluster;

/**
 * @author Vladimir Gordiychuk
 */
public class ExposeAllKvMetrics {

    public static void main(String[] args) throws IOException, InterruptedException {
        var cluster = SolomonCluster.PROD_STORAGE_SAS;
        var client = KikimrHelper.createKvClient(cluster);
        var kvTablets = client.resolveKvTablets(cluster.getSolomonVolumePath()).join();

        var http = HttpClient.newBuilder()
            .version(HttpClient.Version.HTTP_1_1)
            .followRedirects(HttpClient.Redirect.NEVER)
            .connectTimeout(Duration.ofSeconds(30))
            .build();

        for (long tabletId : kvTablets) {
            http.send(HttpRequest.newBuilder()
                .uri(URI.create("http://" + cluster.hosts().get(0) + ":8765/tablets/expose?TabletID=" + Long.toUnsignedString(tabletId)))
                .build(), HttpResponse.BodyHandlers.ofString());
            System.out.println("exposed: " + tabletId);
        }

        System.exit(0);
    }
}
