package ru.yandex.solomon.experiments.gordiychuk;

import java.util.ArrayList;

import com.google.common.net.HostAndPort;
import com.yandex.ydb.table.description.TableDescription;

import ru.yandex.solomon.tool.YdbClient;
import ru.yandex.solomon.tool.YdbHelper;

/**
 * @author Vladimir Gordiychuk
 */
public class FixTablePk {
    private static final String DATABASE = "/global/solomon";
    private static final String ROOT = DATABASE + "/Config/V2";

    public static void main(String[] args) {
        try (var ydb = YdbHelper.createYdbClient(HostAndPort.fromString("127.0.0.55:2135"))) {
//            addPk(ydb, ROOT + "/Dashboard");
//            addPk(ydb, ROOT + "/Graph");
            addPk(ydb, ROOT + "/Shard");
        }
        System.exit(0);
    }

    private static void addPk(YdbClient ydb, String tablePath) {
        var description = ydb.fluent().describeTable(tablePath).join().expect("success describe source table");
        ydb.fluent().executeOnSession(session -> session.copyTable(tablePath, tablePath + 2)).join().expect("success copy");
        ydb.fluent().executeOnSession(session -> session.dropTable(tablePath)).join().expect("success drop prev");
        ydb.fluent().executeOnSession(session -> {
            var targetTable = tablePath + 3;
            return session.createTable(targetTable, patch(description));
        }).join().expect("success create etalon");

        CopyTable.copyTable(ydb, tablePath + "2", tablePath + "3");
//        ydb.fluent().execute("UPSERT INTO [" + tablePath + "3] SELECT * FROM [" + tablePath + "2] offset 100000;").join().expect("success insert into new table");
        ydb.fluent().executeOnSession(session -> session.copyTable(tablePath + 3, tablePath)).join().expect("success copy table back");
        ydb.fluent().executeOnSession(session -> session.dropTable(tablePath + 2)).join().expect("drop tmp table");
        ydb.fluent().executeOnSession(session -> session.dropTable(tablePath + 3)).join().expect("drop tmp table");
    }

    private static TableDescription patch(TableDescription source) {
        assert source.getIndexes().isEmpty();
        var builder = TableDescription.newBuilder();
        for (var column : source.getColumns()) {
            builder.addNonnullColumn(column.getName(), column.getType());
        }
        var pks = new ArrayList<String>();
        if (!source.getPrimaryKeys().contains("projectId")) {
            pks.add("projectId");
        }
        pks.addAll(source.getPrimaryKeys());
        builder.setPrimaryKeys(pks);
        return builder.build();
    }
}
