package ru.yandex.solomon.experiments.gordiychuk;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;

import ru.yandex.misc.dataSize.DataSize;
import ru.yandex.monlib.metrics.MetricType;
import ru.yandex.solomon.codec.archive.MetricArchiveImmutable;
import ru.yandex.solomon.codec.archive.MetricArchiveMutable;
import ru.yandex.solomon.codec.archive.serializer.MetricArchiveImmutableSelfContainedSerializer;
import ru.yandex.solomon.codec.serializer.StockpileDeserializer;
import ru.yandex.solomon.codec.serializer.StockpileFormat;
import ru.yandex.solomon.model.point.AggrPoint;

/**
 * @author Vladimir Gordiychuk
 */
public class StockpileCheckCompression {

    public static void main(String[] args) throws IOException {
        var root = Path.of("/home/gordiychuk/junk/dump");
        var checkFile = root.resolve(MetricType.HIST_RATE.name()).resolve("5529471082625281.v1");

        MetricArchiveImmutable archive = deserialize(Files.readAllBytes(checkFile));
        MetricArchiveMutable v2 = new MetricArchiveMutable(archive.header(), StockpileFormat.CURRENT);
        v2.ensureCapacity(archive.columnSetMask(), archive.getRecordCount());
        AggrPoint point = new AggrPoint(archive.columnSetMask());
        var it = archive.iterator();
        while (it.next(point)) {
            System.out.println(point);
            v2.addRecord(point);
        }

        System.out.println("v1: " + DataSize.shortString(archive.bytesCount()));
        System.out.println("v2: " + DataSize.shortString(v2.bytesCount()));
        System.out.println("v1: " + archive.bytesCount());
        System.out.println("v2: " + v2.bytesCount());
    }

    private static MetricArchiveImmutable deserialize(byte[] bytes) {
        var d = new StockpileDeserializer(bytes);
        return MetricArchiveImmutableSelfContainedSerializer.makeSerializerForVersion(StockpileFormat.CURRENT)
            .deserializeWithLength(d);
    }
}
