package ru.yandex.solomon.experiments.gordiychuk;

import java.util.Arrays;

import ru.yandex.kikimr.client.kv.KikimrKvClient;
import ru.yandex.solomon.tool.KikimrHelper;
import ru.yandex.solomon.tool.cfg.SolomonCluster;

import static org.junit.Assert.assertArrayEquals;
import static org.junit.Assert.assertEquals;

/**
 * @author Vladimir Gordiychuk
 */
public class StockpileIncreaseShards {

    public static void main(String[] args) {
        var cluster = SolomonCluster.PRESTABLE_STORAGE;
        var path = cluster.getSolomonVolumePath();
        KikimrKvClient kvClient = KikimrHelper.createKvClient(cluster);
        long[] initTablets = kvClient.resolveKvTablets(path).join();
        System.out.println("Count: " + initTablets.length);
        System.out.println(Arrays.toString(initTablets));

        kvClient.alterKvTablets(path, 8192).join();
        long[] alteredTablets = kvClient.resolveKvTablets(path).join();
        System.out.println("Count: " + alteredTablets.length);
        System.out.println(Arrays.toString(alteredTablets));

        assertArrayEquals(initTablets, Arrays.copyOf(alteredTablets, initTablets.length));
        assertEquals(8192, alteredTablets.length);

        System.exit(0);
    }
}
