package ru.yandex.solomon.experiments.gordiychuk;

import java.util.stream.Collectors;
import java.util.stream.LongStream;

import ru.yandex.kikimr.client.kv.KikimrKvClient;
import ru.yandex.misc.concurrent.CompletableFutures;
import ru.yandex.solomon.tool.KikimrHelper;
import ru.yandex.solomon.tool.cfg.SolomonCluster;
import ru.yandex.solomon.tool.stockpile.backup.BackupsHelper;
import ru.yandex.stockpile.server.data.names.FileNamePrefix;

import static java.util.stream.Collectors.toList;

/**
 * @author Vladimir Gordiychuk
 */
public class StockpileMakeSnapshot {

    public static void main(String[] args) {
        var cluster = SolomonCluster.PROD_STORAGE_VLA;
        KikimrKvClient kvClient = KikimrHelper.createKvClient(cluster);

        // b20190813T155500.
        // 1565711750
        FileNamePrefix.Backup backup = new FileNamePrefix.Backup(1565711750);
//        deleteBacukps(cluster, kvClient, backup);
        makeBackup(cluster, kvClient, backup);
        System.exit(0);
    }

    private static void deleteBacukps(SolomonCluster cluster, KikimrKvClient kvClient, FileNamePrefix.Backup backup) {
        BackupsHelper helper = new BackupsHelper(kvClient);
        kvClient.resolveKvTablets(cluster.getSolomonVolumePath())
            .thenCompose(tabletIds ->
                LongStream.of(tabletIds)
                    .mapToObj(tabletId -> helper.deleteBackupsAsync(tabletId, 0, backup)
                        .whenComplete((ignore, e) -> {
                            if (e != null) {
                                System.err.println("tablet failed: "+ tabletId);
                                e.printStackTrace();
                            }
                        }))
                    .collect(Collectors.collectingAndThen(toList(), CompletableFutures::allOfVoid))
            )
            .join();
    }

    private static void makeBackup(SolomonCluster cluster, KikimrKvClient kvClient, FileNamePrefix.Backup backup) {
        BackupsHelper helper = new BackupsHelper(kvClient);
        kvClient.resolveKvTablets(cluster.getSolomonVolumePath())
            .thenCompose(tabletIds ->
                LongStream.of(tabletIds)
                    .mapToObj(tabletId -> helper.backupCurrent(tabletId, 0, backup)
                        .whenComplete((ignore, e) -> {
                            if (e != null) {
                                System.err.println("tablet failed: "+ tabletId);
                                e.printStackTrace();
                            }
                        }))
                    .collect(Collectors.collectingAndThen(toList(), CompletableFutures::allOfVoid))
            )
            .join();
    }

}
