package ru.yandex.solomon.experiments.gordiychuk;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.LongStream;

import ru.yandex.kikimr.client.kv.KikimrKvClient;
import ru.yandex.kikimr.util.NameRange;
import ru.yandex.misc.concurrent.CompletableFutures;
import ru.yandex.solomon.tool.KikimrHelper;
import ru.yandex.solomon.tool.cfg.SolomonCluster;
import ru.yandex.stockpile.server.SnapshotLevel;
import ru.yandex.stockpile.server.data.names.StockpileKvNames;

import static java.util.stream.Collectors.toList;

/**
 * @author Vladimir Gordiychuk
 */
public class StockpileRmTest {

    public static void main(String[] args) {
        var cluster = SolomonCluster.TEST;
        KikimrKvClient kvClient = KikimrHelper.createKvClient(cluster);

        List<NameRange> delete = new ArrayList<>();
        delete.addAll(StockpileKvNames.currentSnapshot(SnapshotLevel.ETERNITY));

        kvClient.resolveKvTablets(cluster.getSolomonVolumePath())
            .thenCompose(tabletIds ->
                LongStream.of(tabletIds)
                    .mapToObj(tabletId -> kvClient.deleteRanges(tabletId, 0, delete, expiredAt())
                        .thenCompose(unit -> kvClient.incrementGeneration(tabletId, expiredAt()))
                        .whenComplete((ignore, e) -> {
                            if (e != null) {
                                System.err.println("tablet failed: "+ tabletId);
                                e.printStackTrace();
                            }
                        }))
                    .collect(Collectors.collectingAndThen(toList(), CompletableFutures::allOfVoid))
            )
            .join();
        System.exit(0);
    }

    private static long expiredAt() {
        return System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(5);
    }
}
